#include "global.h"

VALUE cVertex;

/*
static void gts_free(void *p) {
	GtsVertex *cp;
	Data_Get_Struct(p, GtsVertex, cp);
	cp->segments = NULL;
	gts_object_destroy(p);
}
*/

static VALUE vertex_alloc(VALUE klass) {
	return Data_Wrap_Struct(klass, 0, 0, 0);
}

static VALUE vertex_initialize(VALUE obj, VALUE x, VALUE y, VALUE z) {
	DATA_PTR(obj) = gts_vertex_new(gts_vertex_class(), NUM2DBL(x), NUM2DBL(y), NUM2DBL(z));
	return obj;
}

static VALUE vertex_get_neighbors(VALUE self, VALUE surface) { 
	GSList *gslist = NULL, *i;
	GtsVertex *v;
	GtsSurface *s;
	VALUE a;
	a = rb_ary_new();
	Data_Get_Struct(self, GtsVertex, v);
	Data_Get_Struct(surface, GtsSurface, s);
	gslist = gts_vertex_neighbors(v, gslist, s);
	i = gslist;
  while (i) {
		rb_ary_push(a, Data_Wrap_Struct(cVertex, 0, 0, i->data));
    i = i->next;
  }
  g_slist_free(gslist);
	return a;
}

void Init_gts_vertex(void) {
	VALUE mGts = rb_define_module("Gts");
	cVertex = rb_define_class_under(mGts, "Vertex", cPoint);
	rb_define_alloc_func(cVertex, vertex_alloc);
	rb_define_method(cVertex, "neighbors", vertex_get_neighbors, 1);
}

