#include "global.h"

VALUE cTriangle;

static VALUE triangle_alloc(VALUE klass) {
	return Data_Wrap_Struct(klass, 0, 0, 0);
}

static VALUE triangle_initialize(VALUE obj, VALUE e1, VALUE e2, VALUE e3) {
	GtsEdge *ce1, *ce2, *ce3;
	Data_Get_Struct(e1, GtsEdge, ce1);
	Data_Get_Struct(e2, GtsEdge, ce2);
	Data_Get_Struct(e3, GtsEdge, ce3);
	DATA_PTR(obj) = gts_triangle_new(gts_triangle_class(), ce1, ce2, ce3);
	return obj;
}




static VALUE triangle_get_e1(VALUE self) {
	GtsTriangle *t;
	Data_Get_Struct(self, GtsTriangle, t);
	return Data_Wrap_Struct(cEdge, 0, 0, t->e1);
}




static VALUE triangle_get_e2(VALUE self) {
	GtsTriangle *t;
	Data_Get_Struct(self, GtsTriangle, t);
	return Data_Wrap_Struct(cEdge, 0, 0, t->e2);
}




static VALUE triangle_get_e3(VALUE self) {
	GtsTriangle *t;
	Data_Get_Struct(self, GtsTriangle, t);
	return Data_Wrap_Struct(cEdge, 0, 0, t->e3);
}

/*
static VALUE triangle_get_vertices(VALUE self) {

 	GtsTriangle *t;
	GtsVertex *v1, *v2, *v3;
	Data_Get_Struct(self, GtsTriangle, t);

	gts_triangle_vertices (t, &v1, &v2, &v3);
	VALUE a;
	a = rb_ary_new();
	rb_ary_push(a, Data_Wrap_Struct(cVertex, 0, 0, v1));
	rb_ary_push(a, Data_Wrap_Struct(cVertex, 0, 0, v2));
	rb_ary_push(a, Data_Wrap_Struct(cVertex, 0, 0, v3));




}
*/

static VALUE triangle_destroy_enclosing(VALUE self) {
 	GtsTriangle *t;
	GtsVertex *v1, *v2, *v3;
	Data_Get_Struct(self, GtsTriangle, t);
	gts_triangle_vertices (t, &v1, &v2, &v3);
  gts_allow_floating_vertices = TRUE;
  gts_object_destroy (GTS_OBJECT (v1));
  gts_object_destroy (GTS_OBJECT (v2));
  gts_object_destroy (GTS_OBJECT (v3));
  gts_allow_floating_vertices = FALSE;
	return Qnil;
}








static VALUE get_triangle_enclosing(VALUE self, VALUE ary, VALUE scale) {
	GSList *gslist = NULL;
	GtsPoint *cp;
	GtsTriangle *ct;
	int i;
	Check_Type(ary, T_ARRAY);
	for (i = 0; i < RARRAY_LEN(ary); i++) {
		Data_Get_Struct(RARRAY_PTR(ary)[i], GtsPoint, cp);
		gslist = g_slist_prepend(gslist, (gpointer) cp);
	}
	ct = gts_triangle_enclosing(gts_triangle_class(), gslist, NUM2DBL(scale));
	g_slist_free(gslist);
	return Data_Wrap_Struct(cTriangle, 0, 0, ct);
}

void Init_gts_triangle(void) {
	VALUE mGts = rb_define_module("Gts");
	cTriangle = rb_define_class_under(mGts, "Triangle", rb_cObject);
	rb_define_alloc_func(cTriangle, triangle_alloc);
	rb_define_method(cTriangle, "initialize", triangle_initialize, 3);
	rb_define_method(cTriangle, "e1", triangle_get_e1, 0);
	rb_define_method(cTriangle, "e2", triangle_get_e2, 0);
	rb_define_method(cTriangle, "e3", triangle_get_e3, 0);
	rb_define_method(cTriangle, "destroy_enclosing", triangle_destroy_enclosing, 0);



	rb_define_singleton_method(cTriangle, "triangle_enclosing", get_triangle_enclosing, 2);

}

