#include "global.h"

VALUE cSurface;

static VALUE surface_alloc(VALUE klass) {
	return Data_Wrap_Struct(klass, 0, 0, 0);
}

static VALUE surface_initialize(VALUE obj) {
	DATA_PTR(obj) = gts_surface_new(gts_surface_class(), gts_face_class(), gts_edge_class(), gts_vertex_class());
	return obj;
}

static VALUE surface_get_vertex_number(VALUE self) {
	GtsSurface *p;
	Data_Get_Struct(self, GtsSurface, p);
	return UINT2NUM(gts_surface_vertex_number(p));
}

static VALUE surface_get_edge_number(VALUE self) {
	GtsSurface *p;
	Data_Get_Struct(self, GtsSurface, p);
	return UINT2NUM(gts_surface_edge_number(p));
}

static gint surface_vertex_cb(gpointer vertex, gpointer data) {
	if (rb_block_given_p()) {
	  /*rb_yield((VALUE) vertex);*/
		rb_yield(Data_Wrap_Struct(cVertex, 0, 0, vertex));
		/*rb_yield(Data_Wrap_Struct(rb_obj_class((VALUE) vertex), 0, 0, vertex));*/
	}
	return 0;
}

static VALUE surface_foreach_vertex(VALUE self) {
  GtsSurface *s;
	Data_Get_Struct(self, GtsSurface, s);
	gts_surface_foreach_vertex(s, surface_vertex_cb, NULL);
	return Qnil;
}

static gint surface_push_vertex_cb(gpointer vertex, gpointer data) {
	rb_ary_push((VALUE) data, Data_Wrap_Struct(cVertex, 0, 0, vertex));
	return 0;
}

static VALUE surface_get_vertex_array(VALUE self) {
  GtsSurface *s;
	VALUE a;
	Data_Get_Struct(self, GtsSurface, s);
	a = rb_ary_new();
	gts_surface_foreach_vertex(s, surface_push_vertex_cb, (gpointer) a);
	return a;
}





static gint surface_edge_cb(gpointer edge, gpointer data) {
	if (rb_block_given_p()) {
		rb_yield(Data_Wrap_Struct(cEdge, 0, 0, edge));
	}
	return 0;
}

static VALUE surface_foreach_edge(VALUE self) {
  GtsSurface *s;
	Data_Get_Struct(self, GtsSurface, s);
	gts_surface_foreach_edge(s, surface_edge_cb, NULL);
	return Qnil;
}








static VALUE surface_delaunay_add_vertex(VALUE self, VALUE vertex) {
	GtsSurface *p;
	GtsVertex *v, *res;
	Data_Get_Struct(self, GtsSurface, p);
	Data_Get_Struct(vertex, GtsVertex, v);
	if (res = gts_delaunay_add_vertex(p, v, NULL))
		return Data_Wrap_Struct(cVertex, 0, 0, res);
	else
		return Qnil;
}


static VALUE surface_delaunay_add_constraint(VALUE self, VALUE constraint) {
	GtsSurface *p;
	GtsConstraint *c;
	Data_Get_Struct(self, GtsSurface, p);
	Data_Get_Struct(constraint, GtsConstraint, c);
	if (gts_delaunay_add_constraint(p, c) == NULL)
		return Qfalse;
	else
		return Qtrue;
}





static gboolean triangle_is_hole (GtsTriangle * t)
{
  GtsEdge * e1, * e2, * e3;
  GtsVertex * v1, * v2, * v3;

  gts_triangle_vertices_edges (t, NULL, &v1, &v2, &v3, &e1, &e2, &e3);

  if ((GTS_IS_CONSTRAINT (e1) && GTS_SEGMENT (e1)->v1 != v1) ||
      (GTS_IS_CONSTRAINT (e2) && GTS_SEGMENT (e2)->v1 != v2) ||
      (GTS_IS_CONSTRAINT (e3) && GTS_SEGMENT (e3)->v1 != v3))
    return TRUE;
  return FALSE;
}

static guint delaunay_remove_holes (GtsSurface * surface)
{
  g_return_val_if_fail (surface != NULL, 0);

  return gts_surface_foreach_face_remove (surface, 
					  (GtsFunc) triangle_is_hole, NULL);
}


static VALUE surface_delaunay_remove_holes(VALUE self) {
	GtsSurface *p;
	Data_Get_Struct(self, GtsSurface, p);
	return UINT2NUM(delaunay_remove_holes(p));
}









static VALUE surface_add_face(VALUE self, VALUE face) {
	GtsSurface *p;
	GtsFace *f;
	Data_Get_Struct(self, GtsSurface, p);
	Data_Get_Struct(face, GtsFace, f);
	gts_surface_add_face(p, f);
	return Qnil;
}

void Init_gts_surface(void) {
	VALUE mGts = rb_define_module("Gts");
	cSurface = rb_define_class_under(mGts, "Surface", rb_cObject);
	rb_define_alloc_func(cSurface, surface_alloc);
	rb_define_method(cSurface, "initialize", surface_initialize, 0);
	rb_define_method(cSurface, "vertex_number", surface_get_vertex_number, 0);
	rb_define_method(cSurface, "edge_number", surface_get_edge_number, 0);

	rb_define_method(cSurface, "delaunay_add_vertex", surface_delaunay_add_vertex, 1);
	rb_define_method(cSurface, "delaunay_add_constraint", surface_delaunay_add_constraint, 1);
	rb_define_method(cSurface, "delaunay_remove_holes", surface_delaunay_remove_holes, 0);


	rb_define_method(cSurface, "add_face", surface_add_face, 1);
	rb_define_method(cSurface, "each_vertex",  surface_foreach_vertex, 0);
	rb_define_method(cSurface, "each_edge",  surface_foreach_edge, 0);

	rb_define_method(cSurface, "vertices", surface_get_vertex_array, 0);

}

