#include "global.h"

VALUE cPoint;

static void gts_free(void *p) {
	gts_object_destroy(p);
}

static VALUE point_alloc(VALUE klass) {
	return Data_Wrap_Struct(klass, 0, 0, 0);
}

static VALUE point_initialize(VALUE obj, VALUE x, VALUE y, VALUE z) {
	DATA_PTR(obj) = gts_point_new(gts_point_class(), NUM2DBL(x), NUM2DBL(y), NUM2DBL(z));
	return obj;
}

static VALUE point_get_x(VALUE self) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	return DBL2NUM(p->x);
}

static VALUE point_get_y(VALUE self) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	return DBL2NUM(p->y);
}

static VALUE point_get_z(VALUE self) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	return DBL2NUM(p->z);
}

static VALUE point_set_x(VALUE self, VALUE x) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	p->x = NUM2DBL(x);
	return self;
}

static VALUE point_set_y(VALUE self, VALUE y) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	p->y = NUM2DBL(y);
	return self;
}

static VALUE point_set_z(VALUE self, VALUE z) {
	GtsPoint *p;
	Data_Get_Struct(self, GtsPoint, p);
	p->z = NUM2DBL(z);
	return self;
}

void Init_gts_point(void) {
	VALUE mGts = rb_define_module("Gts");
	cPoint = rb_define_class_under(mGts, "Point", rb_cObject);
	rb_define_alloc_func(cPoint, point_alloc);
	rb_define_method(cPoint, "initialize", point_initialize, 3);
	rb_define_method(cPoint, "x", point_get_x, 0);
	rb_define_method(cPoint, "y", point_get_y, 0);
	rb_define_method(cPoint, "z", point_get_z, 0);
	rb_define_method(cPoint, "x=", point_set_x, 1);
	rb_define_method(cPoint, "y=", point_set_y, 1);
	rb_define_method(cPoint, "z=", point_set_z, 1);
}


