#include "global.h"

VALUE cEdge;

static VALUE edge_alloc(VALUE klass) {
	return Data_Wrap_Struct(klass, 0, 0, 0);
}

static VALUE edge_initialize(VALUE obj, VALUE v1, VALUE v2) {
	GtsVertex *cv1, *cv2;
	Data_Get_Struct(v1, GtsVertex, cv1);
	Data_Get_Struct(v2, GtsVertex, cv2);
	DATA_PTR(obj) = gts_edge_new(gts_edge_class(), cv1, cv2);
	return obj;
}

static VALUE edge_get_v1(VALUE self) {
  GtsEdge *e;
	Data_Get_Struct(self, GtsEdge, e);
	return Data_Wrap_Struct(cVertex, 0, 0, GTS_SEGMENT (e)->v1);
}

static VALUE edge_get_v2(VALUE self) {
  GtsEdge *e;
	Data_Get_Struct(self, GtsEdge, e);
	return Data_Wrap_Struct(cVertex, 0, 0, GTS_SEGMENT (e)->v2);
}

void Init_gts_edge(void) {
	VALUE mGts = rb_define_module("Gts");
	cEdge = rb_define_class_under(mGts, "Edge", cSegment);
	rb_define_alloc_func(cEdge, edge_alloc);
	rb_define_method(cEdge, "initialize", edge_initialize, 2);
	rb_define_method(cEdge, "v1",edge_get_v1 , 0);
	rb_define_method(cEdge, "v2",edge_get_v2 , 0);

}

