#!/usr/bin/env ruby
require 'benchmark'
require 'set'

N = 1e6.to_i

class A
  attr_accessor :a, :b, :c
	def d
		@d
	end
	def d=(x)
		@d = x
	end

end



def t00a
  m = A.new
	m.a = 34
	N.times{|er|
		m.b = m.a + 1
		m.c = m.a + m.b
	}
end

def t00b
  m = A.new
	m.a = 34.0
	N.times{|er|
		m.b = m.a + 1.0
		m.c = m.a + m.b
	}
end

def t9
  m = A.new
	N.times{|er|
		m.a = 1
		m.b = m.a
	}
end

def t10
  m = A.new
	N.times{|er|
		m.d = 1
		m.b = m.d
	}
end

def t11
  m = A.new
	b = d = 0
	N.times{|er|
		d = 1
		b = d
	}
end


def t00c
  m = A.new
	m.a = 34
	N.times{|er|
		m.b = m.a + 1
		m.c = Math::atan2(m.a, m.b)
	}
end

def t00d
  m = A.new
	m.a = 34.0
	N.times{|er|
		m.b = m.a + 1.0
		m.c = Math::atan2(m.a, m.b)
	}
end


def ta
  m = (0..99).to_a
	i = 1234
	N.times{|er|
		b = m.include?(i)
	}
end

def t7
  a = true
	b = false
	N.times{|er|
		c = (a != b)
	}
end

def t8
  a = true
	b = false
	N.times{|er|
		c = (a ^ b)
	}
end




def ts
  m = (0..99).to_a.to_set
	i = 7
	N.times{|er|
		b = m.include?(i)
	}
end


def t1
	m = A.new
	m.a = 34
	N.times{|er|
		m.b = m.a + 1
		m.c = m.a + m.b
	}
end

def t2
	m = A.new
	x = 34
	y = 0
	z = 0
	N.times{|er|
		y = x + 1
		z = x + y
	}
end

def t3
	m = A.new
	x = 34
	#y = 0
	#z = 0
	N.times{|er|
		y = x + 1
		z = x + y
	}
end

def t4
	m = A.new
	x = 1.3
	y = 0
	z = 0
	N.times{|er|
		y = Math::sin(x)
		z = Math::sqrt(y)
	}
end

def t5
	a = (0..99).to_a.shuffle!
	a[50] = 50
	y = nil
	N.times{|er|
		y = a.index(50)
	}
end

def t12
	a = 1.2
	b = 12.7
	return a, b
end

def t13
	a = 1.2
	b = 12.7
	[a, b]
end

def t12a
	a = b = 0
	N.times{
		a, b = t12 
	}
end

def t13a
	a = b = 0
	N.times{
		a, b = t13 
	}
end






Benchmark.bmbm do |x|
  x.report("t12") {t12a}
  x.report("t13") {t13a}
#  x.report("t00c") {t00c}
#  x.report("t00c") {t00d}
#  x.report("t5") {t5}
#  x.report("t4") {t4}
end

